<?php include '../header.php'; ?>
<?php include '../sidebar.php'; ?>
<?php include '../content.php'; ?>

<h1>Performance with 50,000 Data Points</h1>
<div class="chart-section-wrapper">
    <div id="chartContainer"></div>
    <span id="timeToRender"></span>
</div>

<?php
    $limit = 50000;
    $y = 100;
    $dataPoints = array();
    for($i = 0; $i < $limit; $i++){
        $y += rand(0, 10) - 5; 
        array_push($dataPoints, array("x" => $i, "y" => $y));
    }
?>

<script>
    window.onload = function () {
        var data = [{
                type: "line",                
                dataPoints: <?php echo json_encode($dataPoints, JSON_NUMERIC_CHECK); ?>
            }];

        //Better to construct options first and then pass it as a parameter
        var options = {
            zoomEnabled: true,
            animationEnabled: true,
            title: {
                text: "Try Zooming - Panning"
            },
            axisY: {
                lineThickness: 1
            },
            data: data  // random data
        };
        
        var chart = new CanvasJS.Chart("chartContainer", options);
        var startTime = new Date();
        chart.render();
        var endTime = new Date();
        document.getElementById("timeToRender").innerHTML = "Time to Render: " + (endTime - startTime) + "ms";
    }
</script>
<style>
    .chart-section-wrapper {
        position: relative;
    }
	#timeToRender {
		position:absolute; 
		top: 5px; 
		font-size: 20px; 
		font-weight: bold; 
		background-color: #d85757;
		padding: 0px 4px;
		color: #ffffff;
	}
</style>

<?php include '../footer.php'; ?>